/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2007, All Rights Reserved  *
*************************************************************************

*************************************************************************
*                                                                       *
*               EEPROM Emulation Driver for S12XS/S12P                  *
*                                                                       *
* FILE NAME     :  DFlashErase.c                                        *
* DATE          :  06.04.2008                                           *
*                                                                       *
* AUTHOR        :  Infosys Team, Mysore                                 *
* E-mail        :  r56611@freescale.com                                 *
*                                                                       *
*************************************************************************/

/******************************* CHANGES *******************************
 0.0a   10.09.2007      Sindhu R01      Initial Version
 1.0    06.04.2008      Sindhu R01      Removed the SSD Configuration
                                        structure. CallBack and
                                        commandArray are global variables.
                                        Pointer to FlashCommandSequence is
                                        removed.
***********************************************************************/

#include "SSD_Types.h"
#include "SSD_SGF18.h"
#include "SSD_SGF18_Internal.h"

/*************************************************************************
*
*  Function Name    : DFlashErase
*  Description      : Perform erase operation on D Flash
*
*  Arguments        : UINT32. UINT32
*  Return Value     : UINT16
*
**************************************************************************/

UINT16 DFlashErase(UINT32 destination, UINT32 size)
{
    UINT16 commandValue;     /* store command value */
    UINT16 globalAddress;    /* store global address bits */
    UINT16 returnCode;       /* return code variable */
    UINT32 endAddress;       /* storing end address */

    returnCode = SGF_OK;

    /* calculating D Flash end address */
    endAddress = destination + size;

    /* checking size alignment (sector 256 Bytes) */
    if(0 != (size % DFLASH_SECTOR_SIZE))
    {
        returnCode = SGF_ERR_SIZE;
    }
    /* range checking */
    else if((destination < DFLASH_BLOCK_START_ADDR) || \
            (destination >= DFLASH_BLOCK_END_ADDR) || \
            (endAddress > DFLASH_BLOCK_END_ADDR) ||  \
            (size > (DFLASH_BLOCK_END_ADDR - DFLASH_BLOCK_START_ADDR)))
    {
        returnCode = SGF_ERR_RANGE;
    }
    else
    {
        commandValue = (((UINT16)(DFLASH_ERASE_SECTOR)) << 8);

        while(0 != size)
        {
            /* preparing passing parameter for 256 Bytes sector erase */
            globalAddress =(UINT16)((destination & GLOBAL_ADDRESS_MASK) >> 16);
            commandArray[0] = (commandValue|globalAddress);
            commandArray[1] = (UINT16)(destination & ADDRESS_OFFSET_MASK);

            /* update size and destination address */
            size -= DFLASH_SECTOR_SIZE;
            destination += DFLASH_SECTOR_SIZE;

            /* calling flash command sequence function to execute the command */
            returnCode = FlashCommandSequence(COMMAND_INDEX1);

            /* checking the success of command execution */
            if(SGF_OK != returnCode)
            {
                break;
            }
        }
    }

    return(returnCode);
}
